<?php
# WebChangePwd 3.1
# for EVO CMS 3.x
# german translated version
#
# Created By Raymond Irving April, 2005
# German Translation info@b-4-u.de 2016
# Modfied for EVO CMS 3.x by info@b-4-u.de 2021-2023
#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

defined('IN_PARSER_MODE') or die();

# load tpl
if(is_numeric($tpl))
	$tpl = ($doc=$modx->getDocuments($tpl)) ? $doc['content']:"Dokument '$tpl' nicht gefunden.";
else if($tpl)
	$tpl = ($chunk=$modx->getChunk($tpl)) ? $chunk:"Chunk '$tpl' nicht gefunden.";
if(!$tpl)
	$tpl = getWebChangePwdtpl();

// extract declarations
$declare = webLoginExtractDeclarations($tpl);
$tpls = explode((isset($declare["separator"]) ? $declare["separator"]:"<!--tpl_separator-->"),$tpl);

if(!$isPostBack && isset($_SESSION['webValidated'])) {
	// display password screen
	$tpl = $tpls[0];
	$tpl = str_replace("[+action+]",$modx->makeUrl($modx->documentIdentifier),$tpl);
	$output .= $tpl;
} 
else if ($isPostBack && isset($_SESSION['webValidated'])) {
	$genpassword = $_POST['newpassword'];
	$passwordgenmethod = $_POST['passwordgenmethod'];
	$passwordnotifymethod = $_POST['passwordnotifymethod'];
	$specifiedpassword = $_POST['specifiedpassword'];
	
	$uid = $modx->getLoginUserID();
	$type = $modx->getLoginUserType();

	// load template
	$tpl = $tpls[0];
	$tpl = str_replace("[+action+]",$modx->makeUrl($modx->documentIdentifier),$tpl);

	// get user record
	if($type=='manager') $ds = $modx->getUserInfo($uid);
	else $ds = $modx->getWebUserInfo($uid);

	// verify password
	if ($passwordgenmethod=="spec" && $_POST['specifiedpassword']!=$_POST['confirmpassword']) {
		$output = webLoginAlert(utf8_encode("Das besttigte Kennwort stimmt nicht mit dem eingegebenen Kennwort berein!"),1).$tpl;
		return;
	}

	// generate a new password for this user
	if($specifiedpassword!="" && $passwordgenmethod=="spec") {
		if(strlen($specifiedpassword) < 8 ) {
			$output = webLoginAlert(utf8_encode("Das Kennwort muss mindestens 8 Zeichen lang sein!")).$tpl;
			return;
		} else {
			$newpassword = $specifiedpassword;
		}
	} elseif($specifiedpassword=="" && $passwordgenmethod=="spec") {
		$output = webLoginAlert(utf8_encode("Bitte Kennwort eingeben!")).$tpl;
		return;
	} elseif($passwordgenmethod=='g') {
		$newpassword = webLoginGeneratePassword(8);
	} else {
		$output = webLoginAlert(utf8_encode("Whlen Sie eine Kennwort-Erstellungsmethode!")).$tpl;
		return;
	}

	// handle notification
	if($passwordnotifymethod=='e') {
		$rt = webLoginSendNewPassword($ds["email"],$ds["username"],$newpassword,$ds["fullname"]);
		if($rt!==true) { // an error occured
			$output = $rt.$tpl;
			return;
		}
		else {
			$newpassmsg = "Das neue Kennwort wurde an hinterlegte E-Mail-Adresse gesandt.";
		}
	}
	else {
		$newpassmsg = "Neues Kennwort: <b>" . htmlspecialchars($newpassword, ENT_QUOTES) . "</b>.";
	}
	
	// save new password to database
	$q = $modx->db->query('UPDATE '. $modx->getFullTableName('users') .' SET `password`= \''. md5($newpassword).'\' WHERE id= '. $ds['internalKey'] .';');
	if(!$q) {
		$output = webLoginAlert(utf8_encode("Das Kennwort konnte nicht gespeichert werden!"));
		return;
	}

	// display change notification
	$tpl = $tpls[1];
	$tpl = str_replace("[+newpassmsg+]",$newpassmsg,$tpl);
	$output .= $tpl;
}

// Returns Default WebChangePwd tpl
function getWebChangePwdtpl(){
	ob_start();
	?>
	<!-- #declare:separator <hr> --> 
	<!-- login form section-->
	<form method="post" name="changepwdfrm" action="[+action+]" style="margin: 0px; padding: 0px;">
	  <table border="0" cellpadding="1" width="300">
		<tr>
		  <td><fieldset style="width:300px">
		  <legend><b>Kennwort &auml;ndern</b></legend>
		  <input type="radio" name="passwordgenmethod" value="g" checked />Kennwort automatisch erzeugen<br />
		  <input type="radio" name="passwordgenmethod" value="spec" />Ich m&ouml;chte selbst ein Kennwort eingeben:<br />
		  <div style="padding-left:20px">
			<table border="0" cellpadding="0">
			  <tr>
				<td style="padding:0px 0px 0px 0px;">
				<label for="specifiedpassword" style="width:120px">Neues Kennwort:</label>
				</td>
				<td style="padding:0px 0px 0px 0px;">
				<input type="password" name="specifiedpassword" onchange="documentdirty=true;" onkeypress="document.changepwdfrm.passwordgenmethod[1].checked=true;" size="20" /><br />
				</td>
			  </tr>
			  <tr>
				<td style="padding:0px 0px 0px 0px;">
				<label for="confirmpassword" style="width:120px">Neues Kennwort best&auml;tigen:</label>
				</td>
				<td style="padding:0px 0px 0px 0px;">
				<input type="password" name="confirmpassword" onchange="documentdirty=true;" onkeypress="document.changepwdfrm.passwordgenmethod[1].checked=true;" size="20" /><br />
				</td>
			  </tr>
			</table>
			<small><span class="warning" style="font-weight:normal">Das Das Kennwort muss mindestens 8 Zeichen lang sein.</span></small>
		  </div>
		  </fieldset><br />
		  <fieldset style="width:300px">
		  <legend><b>Kennwort best&auml;tigen</b></legend>
		  <input type="radio" name="passwordnotifymethod" value="e" />Kennwort per E-Mail senden.<br />
		  <input type="radio" name="passwordnotifymethod" value="s" checked />Kennwort am Bilschirm anzeigen.
		  </fieldset></td>
		</tr>
		<tr>
		  <td align="right"><input type="submit" value="Kennwort &auml;ndern" name="cmdwebchngpwd" />
		  <input type="reset" value="Zur&uuml;cksetzen" name="cmdreset" />
		  </td>
		</tr>
	  </table>
	</form>
	<hr>
	<!-- notification section -->
	Das Kennwort wurde erfolgreich ge&auml;ndert.<br /><br />
	[+newpassmsg+]
	<?php 
	$t = ob_get_contents();
	ob_end_clean();
	return $t;
}
?>